# 9db量化交易助手 - 快速配置指南


## 🎯 配置概览

本指南将帮您快速完成系统配置，让您能够立即开始自动交易。使用**一键安装工具**，整个配置过程仅需3-5分钟。

### ✅ 配置清单
- [ ] 运行一键安装程序（自动安装Edge、同花顺、量化交易助手）
- [ ] 重启电脑
- [ ] 首次登录同花顺交易系统
- [ ] 配置同花顺委托弹窗设置
- [ ] 准备9db账户信息
- [ ] 启动程序并完成自动授权

---

## 💻 系统要求

在开始配置前，请确认您的系统满足以下要求：

- **操作系统**：Windows 10/11/Server 2016+ (64位)
- **内存**：最少2GB RAM
- **硬盘空间**：至少1GB可用空间
- **网络**：稳定的互联网连接
- **必需软件**：
  - Microsoft Edge浏览器（一键安装工具自动安装）
  - 同花顺客户端（一键安装工具自动安装）

---

## 🎯 步骤1：一键安装（推荐）

> ⚠️ **安全提示**：从网络下载的程序首次运行时，Windows可能会弹出安全警告，这是正常的系统保护机制，请按以下说明操作允许运行。

#### Windows SmartScreen 保护弹窗处理

**类型一：Windows 已保护你的电脑**

如果看到此弹窗，点击"更多信息"，然后点击"仍要运行"：

![SmartScreen保护弹窗1](https://api.qtsig.com/complete/trading_system/auto_install/%E5%85%81%E8%AE%B8%E8%BF%90%E8%A1%8C.png)

![点击仍要运行](https://api.qtsig.com/complete/trading_system/auto_install/%E5%85%81%E8%AE%B8%E8%BF%90%E8%A1%8C2.png)

**类型二：批处理文件运行提示**

如果看到此弹窗，点击"运行"：

![批处理文件运行提示](https://api.qtsig.com/complete/trading_system/auto_install/bat%E5%85%81%E8%AE%B8%E8%BF%90%E8%A1%8C.png)

---

### 1.1 运行一键安装程序
```
获取一键安装程序，下载并解压，双击目录中的 9dbAutoTrader_Install.exe
```

### 1.2 全自动安装流程
一键安装工具会自动完成以下安装：
```
第一步：安装 Microsoft Edge 浏览器
    ↓ 检测是否已安装 → 下载 → 静默安装 → 设置默认浏览器
第二步：安装同花顺交易客户端
    ↓ 下载安装包 → 静默安装 → 创建桌面快捷方式
第三步：安装9db量化交易助手
    ↓ 下载压缩包 → 解压到目标目录 → 创建桌面快捷方式
第四步：运行系统优化脚本
    ↓ 禁用休眠/屏保/锁屏/自动更新
```

### 1.3 安装完成后
桌面会自动创建以下快捷方式：
- **Microsoft Edge** - 浏览器
- **同花顺交易客户端** - xiadan.exe（股票交易）
- **同花顺** - hexin.exe（行情分析）
- **9dbAutoTrader** - 量化交易助手主程序
- **退出远程桌面** - 远程桌面管理工具

> ⚠️ **重要**：安装完成后请**重启电脑**，确保所有系统设置生效！

---

## 🔧 步骤2：同花顺首次配置

**重要：必须先完成同花顺配置，再启动交易程序**

### 2.1 首次登录（仅操作一次）
1. 双击桌面"同花顺"图标启动同花顺主程序
2. 登录同花顺账户（同花顺注册账户）
3. 按**F12键**打开交易系统，登录证券交易账户
    - ⚠️ **重要：登录时勾选"保存密码"和"自动登录"选项框**
4. 确认登录成功后，关闭退出同花顺主程序

### 2.2 日常使用
1. 双击桌面"同花顺交易客户端"快捷方式
2. 交易系统会自动继承之前的登录状态
3. **保持交易系统窗口可见，不要最小化**

> 💡 **提示**：一键安装工具已自动创建"同花顺交易客户端"桌面快捷方式

#### ⚠️ 重要：同花顺系统设置

> **关键设置**：为确保程序能够正确检测交易执行结果，必须进行以下系统设置：

**步骤说明：**
1. **打开同花顺交易系统**：启动桌面 `同花顺交易客户端` 快捷方式
2. **进入系统设置**：在交易系统界面中找到"系统">>"系统设置"菜单
3. **找到委托设置**：在“快速交易"选项中找到"委托成功后是否弹出提示对话框"
4. **选择"是"**：⚠️ **务必选择"是"**，不要选择"否"
5. **保存设置**：确认并保存设置

![委托完成后提示对话框](https://api.qtsig.com/complete/trading_system/%E4%BA%A4%E6%98%93%E5%A7%94%E6%89%98%E5%BC%B9%E6%A1%86%E8%AE%BE%E7%BD%AE.png)

> **注意**：此设置是系统交易正常运行的前提条件，请务必确认已正确配置！


---

## 🛡️ 步骤3：正确断开远程桌面（如适用）

### 3.2 远程桌面正确断开
**重要：如果使用远程桌面，必须正确断开**

1. 程序目录下已提供 `退出远程桌面.bat` 文件
2. **每次断开远程桌面前**：
   - 右键点击桌面 `退出远程桌面.bat`
   - 选择"以管理员身份运行"
   - 等待窗口自动关闭，远程桌面将自动断开

> **注意**：请勿直接关闭远程桌面窗口，否则可能导致交易失败

---

## 🚀 步骤4：启动交易程序

### 4.1 启动前检查
- [ ] 同花顺交易系统已打开并可见
- [ ] 9db账户信息准备就绪（邮箱+密码）
- [ ] 网络连接正常
- [ ] 系统环境已设置（已运行自动批处理文件）

### 4.2 启动交易程序
1. **以管理员身份**运行 `9dbAutoTrader.exe`
2. **首次运行时**，系统会自动检测配置：
   - 如需授权，浏览器会自动打开授权页面
   - 在浏览器中登录9db账户并确认授权
   - 等待系统自动生成配置文件
3. **授权完成后**，看到此提示表示启动成功：
   ```
   ==========程序启动成功 开始主交易循环 ==========
   ```

![程序启动成功界面](https://api.qtsig.com/complete/trading_system/system_info.png)

### 4.3 首次授权说明
首次运行时，程序会自动检测是否需要授权配置：

**自动授权流程：**
1. **直接启动程序** - 双击 `9dbAutoTrader.exe`
2. **自动检测配置** - 系统自动检测是否需要授权
3. **打开授权页面** - 如需授权，浏览器自动打开9db授权页面
4. **完成授权登录** - 在浏览器中登录您的9db账户并确认授权
5. **自动生成配置** - 系统自动获取配置信息并生成 `config_main.ini` 文件
6. **开始交易** - 配置完成后程序自动开始运行

**授权界面示例：**
```
============================================================
🔐 需要进行用户授权配置
============================================================
📋 授权页面已自动打开，请在浏览器中完成以下步骤：
   1. 登录您的9db账户
   2. 确认授权此应用程序
   3. 等待系统自动获取配置信息...
============================================================
💡 授权会话ID: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
⏰ 最大等待时间: 600秒
============================================================
```

> **温馨提示**：只需要您的9db账户即可完成所有配置，简单快捷！

### 4.4 验证运行状态
- 交易时间内定期回传账户信息
- 交易时间内能看到系统状态更新
- 日志文件正常生成

---

## ⏰ 交易时间说明

**系统仅在以下时间自动交易**：
- **上午**：9:05 - 11:32
- **下午**：12:50 - 15:02
- **交易日**：周一至周五（节假日除外）

---

## 📞 获取帮助

### 配置支持
- **官方网站**：https://www.9db.com
- **服务时间**：工作日 9:00-18:00
- **下载地址**：[9dbAutoTrader](https://github.com/9dbQuant/9dbAutoTrader)

### 紧急联系
如遇配置问题无法解决，请提供：
1. 错误截图或日志文件
2. 系统版本和同花顺版本
3. 9db账户信息（用于检查授权状态）
4. 网络环境说明（如使用VPN等）

---


*配置完成后，您的9db智能量化交易助手就可以开始自动跟单了！*
*如有疑问，请参考完整版《[9dbAutoTrader使用手册.md](9dbAutoTrader使用手册.md)》*

**版本**：快速配置指南 v2.0
**更新时间**：2025年12月
