# 9db量化交易助手 用户使用手册

## 📖 系统概述

**9db量化交易助手**是一款专业的股票自动跟单交易软件，通过API接收量化交易信号并自动执行买卖操作。系统集成了同花顺客户端，实现了完全自动化的股票交易流程。

### 🎯 核心功能
- **自动跟单交易**：接收远程交易信号，自动执行买入/卖出操作
- **多重价格源**：支持新浪、腾讯、同花顺三种价格源，确保买卖价格数据准确性
- **智能风控**：交易时间检查、价格合理性验证、资金余额监控
- **实时监控**：订单状态跟踪、持仓管理、成交记录查询
- **自动更新**：支持远程版本检测和自动更新
- **异常处理**：完善的错误处理机制和日志记录

### ⚡ 系统特点
- **高可靠性**：多重异常处理和网络重试机制
- **实时响应**：秒级交易信号处理
- **数据安全**：本地数据库存储，支持数据备份
- **界面友好**：详细的运行状态提示和日志记录

---

## 🚀 安装部署

### 系统要求
- **操作系统**：Windows 10/11/Server 2016+ (64位)
- **内存**：最少2GB RAM
- **硬盘空间**：至少1GB可用空间
- **网络**：稳定的互联网连接
- **必需软件**：
  - Microsoft Edge浏览器（一键安装工具自动安装）
  - 同花顺客户端（一键安装工具自动安装）

### 🎯 一键安装（推荐）

系统提供**一键安装工具**，可自动完成所有依赖组件的安装：

> ⚠️ **安全提示**：从网络下载的程序首次运行时，Windows可能会弹出安全警告，这是正常的系统保护机制，请按以下说明操作允许运行。

#### Windows SmartScreen 保护弹窗处理

**类型一：Windows 已保护你的电脑**

如果看到此弹窗，点击"更多信息"，然后点击"仍要运行"：

![SmartScreen保护弹窗1](https://api.qtsig.com/complete/trading_system/auto_install/%E5%85%81%E8%AE%B8%E8%BF%90%E8%A1%8C.png)

![点击仍要运行](https://api.qtsig.com/complete/trading_system/auto_install/%E5%85%81%E8%AE%B8%E8%BF%90%E8%A1%8C2.png)

**类型二：批处理文件运行提示**

如果看到此弹窗，点击"运行"：

![批处理文件运行提示](https://api.qtsig.com/complete/trading_system/auto_install/bat%E5%85%81%E8%AE%B8%E8%BF%90%E8%A1%8C.png)

---

#### 安装内容
一键安装工具会自动完成以下安装：
1. **Microsoft Edge浏览器** - 从微软官网下载并静默安装
2. **同花顺交易客户端** - 从官网下载并静默安装
3. **9db量化交易助手** - 下载并解压到 `C:\9dbAutoTrader`
4. **系统优化设置** - 自动禁用休眠、屏保、锁屏和自动更新

#### 安装步骤

**方法1：双击运行（最简单）**
```
获取一键安装程序，下载并解压，双击目录中的 9dbAutoTrader_Install.exe
```

#### 全自动安装流程
```
第一步：安装 Microsoft Edge 浏览器
    ↓ 检测是否已安装 → 下载 → 静默安装 → 设置默认浏览器
第二步：安装同花顺交易客户端
    ↓ 下载安装包 → 静默安装 → 创建桌面快捷方式
第三步：安装9db量化交易助手
    ↓ 下载压缩包 → 解压到目标目录 → 创建桌面快捷方式
第四步：运行系统优化脚本
    ↓ 禁用休眠/屏保/锁屏/自动更新
```

#### 安装完成后
桌面会自动创建以下快捷方式：
- **Microsoft Edge** - 浏览器
- **同花顺交易客户端** - xiadan.exe（股票交易）
- **同花顺** - hexin.exe（行情分析）
- **9dbAutoTrader** - 量化交易助手主程序
- **退出远程桌面** - 远程桌面管理工具

> ⚠️ **重要**：安装完成后请**重启电脑**，确保所有系统设置生效！

---

### 📦 手动安装（备选方案）

如果一键安装失败，可按以下步骤手动安装：

#### 1. 安装 Edge 浏览器
- 下载地址：[Microsoft Edge](https://www.microsoft.com/zh-cn/edge/download)
- 安装完成后设置为默认浏览器

#### 2. 安装同花顺客户端
- 下载地址：[同花顺官网](https://download.10jqka.com.cn/free/ths/)
- 安装完成后创建桌面快捷方式

#### 3. 安装9db量化交易助手
- 下载系统安装包 `9dbAutoTrader_vX.X.X.zip`
- 解压到 `C:\9dbAutoTrader` 目录



### 启动前准备

#### 启动同花顺网上交易系统5.0

- **首次使用**：启动完整的同花顺客户端（只操作一次）
  - 双击桌面**"同花顺"**图标启动同花顺主程序
  - 先登录同花顺客户端（使用同花顺账户）
      - 在同花顺主程序中按**F12键**自动打开交易系统
      - ⚠️ **重要：登录账号时需要勾选"保存密码"和"自动登录"选项框**
  - 再用证券账户登录同花顺交易系统，确保登录成功
  - 登录完成后，关闭退出同花顺主程序（网上交易系统也会同步退出）

- **日常使用**：单独启动同花顺交易系统
  - 双击桌面"同花顺交易客户端"快捷方式（一键安装已自动创建）
  - 交易系统会自动继承之前的登录状态
  - 保持"交易系统窗口"可见且未最小化

> 💡 **提示**：一键安装工具已自动创建"同花顺交易客户端"桌面快捷方式

#### ⚠️ 重要：同花顺系统设置

> **关键设置**：为确保程序能够正确检测交易执行结果，必须进行以下系统设置：

**步骤说明：**
1. **打开同花顺交易系统**：启动桌面 `同花顺交易客户端`
2. **进入系统设置**：在交易系统界面中找到"系统">>"系统设置"菜单
3. **找到委托设置**：在“快速交易"选项中找到"委托成功后是否弹出提示对话框"
4. **选择"是"**：⚠️ **务必选择"是"**，不要选择"否"
5. **保存设置**：确认并保存设置

**设置重要性：**
- ✅ **必须开启**：程序依赖委托成功提示对话框来确认交易是否执行成功
- ❌ **禁止关闭**：如果关闭此设置，程序将无法正确判断交易结果
- 🔄 **实时监控**：开启后程序能够实时监控每笔交易的执行状态
- 📊 **准确统计**：确保交易成功率统计和资金计算的准确性

![委托完成后提示对话框](https://api.qtsig.com/complete/trading_system/%E4%BA%A4%E6%98%93%E5%A7%94%E6%89%98%E5%BC%B9%E6%A1%86%E8%AE%BE%E7%BD%AE.png)
> **注意**：此设置是系统正常运行的前提条件，请务必确认已正确配置！


### 安装步骤

#### 使用一键安装（推荐）
```bash
# 运行一键安装程序
双击 9dbAutoTrader_Install.exe
```
一键安装会自动完成Edge、同花顺和9db量化交易助手的安装。

#### 手动安装（如一键安装失败）
1. 下载系统安装包 `9dbAutoTrader_vX.X.X.zip`
2. 解压到 `C:\9dbAutoTrader` 目录
3. 双击运行 `9dbAutoTrader.exe`

> **重要提示**：首次运行可能需要几秒钟的初始化时间，请耐心等待。

#### 文件结构
安装完成后，系统目录结构如下：
```
📁 C:\9dbAutoTrader\
├── 9dbAutoTrader.exe        # 主程序
├── config_main.ini             # 配置文件（首次授权后自动生成）
├── 退出远程桌面.bat            # 远程桌面管理工具
├── 禁止休眠屏保锁屏更新.bat    # 系统优化脚本
├── 📁 logs/                    # 日志文件夹
│   ├── system.log              # 系统日志
│   ├── trading.log             # 交易日志
│   ├── network.log             # 网络请求日志
│   └── trading_log_YYYYMMDD.txt # 每日交易日志
├── trading_data.db             # 本地数据库
└── 📁 temp_update/             # 临时更新文件夹
```

---

## ⚙️ 交易授权

### 🚀 智能自动授权


#### 首次启动流程：
1. **直接启动程序** - 打开安装目录双击 `9dbAutoTrader.exe`
2. **自动检测配置** - 系统自动检测是否需要授权
3. **打开授权页面** - 如需授权浏览器自动打开9db授权页面
4. **完成授权登录** - 在浏览器中登录您的9db账户并确认授权
5. **自动生成配置** - 系统自动获取配置信息并生成 `config_main.ini` 文件
6. **开始交易** - 配置完成后程序自动开始运行

#### 授权界面说明：
```
============================================================
🔐 需要进行用户授权配置
============================================================
📋 授权页面已自动打开，请在浏览器中完成以下步骤：
   1. 登录您的9db账户
   2. 确认授权此应用程序
   3. 等待系统自动获取配置信息...
============================================================
💡 授权会话ID: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
⏰ 最大等待时间: 600秒
============================================================
```

---

### 📦 启动前准备资料

为确保能快速完成配置与开通跟单，请在启动前准备以下资料：

- 9db账户（登录邮箱）
- 证券账户（券商及资金账号）
- 订阅的交割单（量化策略名称）
- 初始资金（用于实盘跟单的可用资金）
- 佣金（万分比/折扣，未知可咨询券商）
- 如有多账户/多策略的对应关系说明

---

### ⚠️ 极其重要：正确断开远程桌面（避免交易失败）

**如果是通过远程工具连接远程电脑，请务必使用下述方式断开远程桌面；直接关闭RDP窗口会导致交易程序操控量化交易助手失败/窗口最小化，可能导致自动下单失败。**


#### 正确断开步骤
1. 程序目录下已提供配置好的 `退出远程桌面.bat` 文件
2. **每次远程断开前**：
   - 右键点击 `退出远程桌面.bat`
   - 选择"以管理员身份运行"
   - 等待窗口自动关闭，远程桌面将自动断开

> 重要：请不要直接点"关闭远程桌面"或直接断电/断网，否则极易导致交易失败。

---

### ⚠️ 极其重要：关闭屏保/自动锁屏/休眠与系统自动更新

**为确保交易过程不被系统行为打断，系统已提供自动化设置工具！**

#### 🚀 一键安装已自动配置

如果您使用**一键安装工具**完成安装，系统优化设置已**自动执行**，包括：
- ✅ 关闭屏幕保护程序
- ✅ 禁用自动锁屏
- ✅ 关闭自动休眠功能
- ✅ 暂停 Windows 自动更新
- ✅ 设置合适的电源管理策略

> ⚠️ **重要**：安装完成后请**重启电脑**，确保所有设置生效！

#### 🔧 手动执行（如需重新配置）

如果需要重新配置系统优化设置：

1. **使用批处理工具**：
   - 进入 `C:\9dbAutoTrader` 目录
   - 右键点击 `禁止休眠屏保锁屏更新.bat`
   - 选择"以管理员身份运行"
   - 等待批处理自动完成所有设置
   - **设置完成后重启电脑**

2. **手动设置（备用方案）**：
   - **关闭屏幕保护程序与自动锁屏**
     - 系统设置 → 个性化 → 锁屏界面 → 屏幕保护程序设置 → 选择"无"
     - 系统设置 → 账户 → 登录选项 → 需要登录（改为"从不"）
   - **关闭自动休眠功能**
     - 系统设置 → 系统 → 电源和睡眠 → 将"睡眠"设置为"从不"
   - **关闭 Windows 自动更新**
     - 系统设置 → Windows 更新 → 暂停更新

> **重要提醒**：交易日内避免系统更新、重启、休眠或锁屏，这些都可能导致自动下单失败。

---

## 🏃 运行启动

#### 1. 检查网络连接
- 确保网络连接稳定
- 可以正常访问互联网
- 防火墙允许程序访问网络

#### 2. 系统权限
- 以管理员权限运行程序 (推荐)
- 确保程序有读写文件的权限

### 启动方式

#### 直接启动
```bash
双击 9dbAutoTrader.exe
```

### 启动界面说明

程序启动后会显示系统信息横幅：

![程序启动成功界面](https://api.qtsig.com/complete/trading_system/system_info.png)

当看到 ==========程序启动成功 开始主交易循环 ==========
表示程序已启动完成，正在等待交易信号


---

## 📊 功能详解

### 自动交易流程

#### 1. 信号接收
```
系统每秒向服务器请求交易信号
↓
验证信号格式和账户匹配
↓
转换为标准交易指令
```

#### 2. 交易执行
```
检查交易时间 (9:00-11:32, 12:50-15:02)
↓
获取实时股价 (新浪/腾讯/同花顺)
↓
执行买入/卖出操作
↓
记录交易结果
```

#### 3. 状态监控
```
实时监控订单状态
↓
更新持仓信息
↓
上传交易数据到服务器
```

### 交易类型支持

#### 价格类型
- **限价单**：按指定价格下单
- **市价单**：按当前市价下单
- **买五价/卖五价**：按五档深度价格下单（目前系统默认）

#### 操作类型
- **买入操作**：自动买入股票
- **卖出操作**：自动卖出股票
- **撤单操作**：撤销未成交订单

### 风控机制

#### 时间控制
- 交易时间：周一至周五 9:05-11:32, 12:50-15:02
- 非交易时间自动暂停交易信号处理
- 支持手动禁用时间检查

#### 价格保护
系统具备智能价格保护机制，防止异常价格下单：
- **买入保护**：买五价不能高于当前价的配置阈值（默认2%）
- **卖出保护**：卖五价不能低于当前价的配置阈值（默认2%）
- **阈值可配置**：可在配置文件中修改价格保护阈值

```
买五价 > 当前价 * (1 + 价格保护阈值):
    跳过下单

卖五价 < 当前价 / (1 + 价格保护阈值):
    跳过下单
```


#### 资金监控
- 实时检查可用资金余额
- 资金不足时停止交易
- 自动防止超资金下单
---


### 停止系统
- **正常停止**：Ctrl+C 或关闭控制台窗口
- **强制停止**：任务管理器结束进程
- 系统会自动保存当前状态和清理资源
---


### 日志文件

#### 系统日志
- `logs/system.log`: 系统运行日志
- `logs/trading.log`: 交易执行日志
- `logs/network.log`: 网络请求日志
- `logs/errors.log`: 错误日志

#### 交易日志
- `logs/trading_log_YYYYMMDD.txt`: 每日交易详细记录
- JSON格式，便于数据分析

### 数据清理
- 自动清理：每小时清理过期临时数据
- 保留期限：默认保留30天历史数据
- 手动清理：删除对应日志文件

---

## 🔄 自动更新

### 更新机制

系统支持自动检测和更新：

#### 更新流程
```
启动时检查远程版本 (每小时只检查1次)
↓
发现新版本时提示用户
↓
开始下载新版本
↓
自动替换程序文件
↓
重启系统完成更新
```


### 手动更新

如遇自动更新失败：

1. **下载新版本**：从官方渠道获取最新版本
2. **停止旧程序**：完全关闭正在运行的程序
3. **替换文件**：用新版本替换旧的exe文件
4. **保留配置**：不要删除配置文件和数据库
5. **重新启动**：运行新版本程序

### 版本兼容性
- 配置文件向后兼容
- 数据库结构自动升级
- 旧版本数据可无缝迁移

---

## ⚠️ 注意事项

### 运行环境要求

#### 同花顺客户端
```
✅ 必须使用同花顺客户端中的"网上股票交易系统5.0"
✅ 交易子系统必须成功登录股票账户
✅ 保持交易系统窗口在系统运行期间开启、可见且不最小化
❌ 不支持其他券商交易客户端/不支持其他版本的同花顺交易客户端
```

#### 系统环境
```
✅ Windows 10/11 64位系统
✅ 管理员权限运行（推荐）
✅ 稳定的网络连接
```

### 安全风险提示

#### 账户安全
- 确保UserID和accID的保密性
- 定期检查交易记录的准确性
- 监控账户异常交易行为

#### 资金安全
- 定期检查账户资金变化
- 出现异常时立即停止系统运行

#### 系统安全
- 不要在公共网络环境下运行
- 定期更新系统到最新版本
- 避免与其他交易软件同时运行

### 性能优化建议

#### 系统资源
- 关闭不必要的后台程序
- 确保足够的系统内存
- 定期清理临时文件

#### 网络环境
- 使用有线网络连接（推荐）

---

## 🔧 故障排除

### 常见问题及解决方案

#### 1. 程序无法启动

**问题现象**：
- 双击程序没有反应
- 出现"应用程序无法正常启动"错误

**解决方案**：
```
1. 检查系统是否为Windows 10/11 64位
2. 以管理员权限运行程序
3. 检查杀毒软件是否误报
4. 重新下载程序文件
```

#### 2. 自动授权失败

**问题现象**：
```
❌ 配置无效且自动授权失败
⏳ 等待授权超时，程序将在30秒后退出
```

**解决方案**：
```
1. 检查网络连接是否正常
2. 确认9db账户邮箱密码正确
3. 检查浏览器是否正常打开授权页面
4. 在授权页面完成登录和确认授权
5. 如仍失败，联系9db官方客服
```

#### 3. 配置文件错误

**问题现象**：
```
❌ 配置文件读取失败: xxx
❌ 配置验证失败，跳过自动更新
```

**解决方案**：
```
1. 删除config_main.ini文件，重新启动程序进行自动授权
2. 或手动检查config_main.ini文件格式
3. 确认UserID为9db提供正确的UUID格式
```

#### 4. 同花顺连接失败

**问题现象**：
```
同花顺客户端初始化失败,请检查同花顺是否打开
```

**解决方案**：
```
1. 确认同花顺客户端已打开并登录
2. 检查是否使用同花顺客户端中的"网上股票交易系统5.0"
3. 重新启动同花顺交易客户端
4. 确保同花顺没有被其他程序占用
```

#### 5. 网络连接异常

**问题现象**：
```
API请求失败: HTTP 404
网络请求异常 - 类型: timeout
```

**解决方案**：
```
1. 检查网络连接是否正常
2. 确认防火墙没有阻止程序访问
3. 尝试更换网络环境
4. 联系9db获取帮助
```

#### 6. 交易时间问题

**问题现象**：
```
[提示] 当前为非交易时间，等待交易时间...
```

**解决方案**：
```
1. 确认当前时间是否为交易时间
   - 周一至周五 9:00-11:32
   - 周一至周五 12:50-15:02
3. 检查系统时间是否准确
```

#### 7. 交易执行无法确认或交易状态检测失败

**问题现象**：
```
- 系统显示交易已发送，但无法确认是否成功
- 交易成功率统计不准确
- 程序无法检测到委托执行结果
```

**解决方案**：
```
⚠️ 检查同花顺系统设置（重要）：
1. 打开同花顺交易系统(xiadan.exe)
2. 找到"系统"或"设置"菜单
3. 找到"委托成功后是否弹出提示对话框"选项
4. 务必选择"是"（不要选择"否"）
5. 保存设置并重启交易系统

原因说明：
- 程序依赖委托成功提示对话框来确认交易执行结果
- 如果关闭此设置，程序无法判断交易是否成功
- 这会导致交易统计错误和后续交易逻辑异常
```

### 高级故障排除

#### 日志分析

查看详细错误信息：
```bash
# 查看系统日志
type logs\system.log

# 查看最新错误
type logs\errors.log

# 查看网络日志
type logs\network.log
```

#### 联系技术支持

如果问题无法解决，请提供：
1. 系统版本信息
2. 错误日志文件
3. 配置文件内容（隐藏敏感信息）
4. 问题复现步骤

---

## 📞 技术支持

### 官方支持渠道
- **官方网站**：https://www.9db.com
- **服务时间**：工作日 9:00-18:00
- **下载地址**：[9dbAutoTrader](https://github.com/9dbQuant/9dbAutoTrader)


### 常用资源

- **用户手册**：系统目录下的用户手册文件


---

## 📝 附录

### 系统架构说明

```
┌─────────────────┐    ┌──────────────────┐    ┌─────────────────┐
│   远程API服务    │    │   本地量化交易助手    │    │   同花顺客户端   │
│    (信号源)      │────│  (信号处理)      │────│   (执行交易)    │
└─────────────────┘    └──────────────────┘    └─────────────────┘
         │                        │                        │
    HTTP REST API           异步处理循环            Windows API
    交易信号推送              实时监控               界面自动操作
```

## 📄 版权声明

本软件由**9点半交割单学院**开发，版权所有。

- 软件仅供授权用户使用
- 禁止逆向工程、反编译或修改
- 使用过程中请遵守相关法律法规
- 投资有风险，使用需谨慎

**免责声明**：本软件仅作为交易工具使用，不构成投资建议。用户应当独立判断投资决策，自行承担投资风险。

---

*最后更新时间：2025年12月*
*版本：v1.3.8*
*文档版本：v2.0*
*新增一键安装工具支持*
